import java.util.concurrent.CountDownLatch;

class CountDownLatchDemo {
	static void waitAndLiftOff(CountDownLatch cdl) {
		try {
			System.out.println("Raketen-Thread wartet auf CountDownLatch");
			cdl.await();
			System.out.println("\n\nRakete startet:");
			for (int i = 1; i <= 16; i++) {
				System.out.print(".");
				for (int j = 0; j < i / 2; j++) System.out.print(" ");
				Thread.sleep(300);
			}
		} catch (InterruptedException ie) {
			/* Ignorieren ist OK, weil kein Interrupt signalisiert wird. */ }
	}

	public static void main(String[] args) throws InterruptedException {
		int cdn = 10;
		var cdl = new CountDownLatch(cdn);
		new Thread(() -> waitAndLiftOff(cdl)).start();
		Thread.sleep(300);
		System.out.println("\nCountdown läuft:");
		for (int i = cdn; i > 0; i--) {
			System.out.print(i + " ");
			cdl.countDown();
			Thread.sleep(500);
		}
	}
}
